/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatchannelinfo.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatChannelInfo(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatChannelInfo");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatChannelInfo();

        LookupJavaMethod(jEnv, info, "copy", "()Ltv/twitch/chat/ChatChannelInfo;"); // public tv.twitch.chat.ChatChannelInfo copy();

        LookupJavaField(jEnv, info, "name", "Ljava/lang/String;"); // public java.lang.String name;
        LookupJavaField(jEnv, info, "broadcasterLanguage", "Ljava/lang/String;"); // public java.lang.String broadcasterLanguage;
        LookupJavaField(jEnv, info, "localUserRestriction", "Ltv/twitch/chat/ChatRestrictionReason;"); // public tv.twitch.chat.ChatRestrictionReason localUserRestriction;
    }

    return info;
}
