/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatchannelrestrictions.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatChannelRestrictions(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatChannelRestrictions");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatChannelRestrictions();

        LookupJavaField(jEnv, info, "followersDuration", "I"); // public int followersDuration;
        LookupJavaField(jEnv, info, "slowModeDuration", "I"); // public int slowModeDuration;
        LookupJavaField(jEnv, info, "emoteOnly", "Z"); // public boolean emoteOnly;
        LookupJavaField(jEnv, info, "verifiedOnly", "Z"); // public boolean verifiedOnly;
        LookupJavaField(jEnv, info, "followersOnly", "Z"); // public boolean followersOnly;
        LookupJavaField(jEnv, info, "subscribersOnly", "Z"); // public boolean subscribersOnly;
        LookupJavaField(jEnv, info, "slowMode", "Z"); // public boolean slowMode;
        LookupJavaField(jEnv, info, "r9k", "Z"); // public boolean r9k;
        LookupJavaField(jEnv, info, "slowModeSetAt", "I"); // public int slowModeSetAt;
    }

    return info;
}
