/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatcomment.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatComment(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatComment");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatComment();

        LookupJavaField(jEnv, info, "messageInfo", "Ltv/twitch/chat/ChatMessageInfo;"); // public tv.twitch.chat.ChatMessageInfo messageInfo;
        LookupJavaField(jEnv, info, "replies", "[Ltv/twitch/chat/ChatComment;"); // public tv.twitch.chat.ChatComment[] replies;
        LookupJavaField(jEnv, info, "commentId", "Ljava/lang/String;"); // public java.lang.String commentId;
        LookupJavaField(jEnv, info, "parentCommentId", "Ljava/lang/String;"); // public java.lang.String parentCommentId;
        LookupJavaField(jEnv, info, "contentId", "Ljava/lang/String;"); // public java.lang.String contentId;
        LookupJavaField(jEnv, info, "channelId", "I"); // public int channelId;
        LookupJavaField(jEnv, info, "timestampMilliseconds", "I"); // public int timestampMilliseconds;
        LookupJavaField(jEnv, info, "updatedAt", "I"); // public int updatedAt;
        LookupJavaField(jEnv, info, "commentSource", "Ltv/twitch/chat/ChatCommentSource;"); // public tv.twitch.chat.ChatCommentSource commentSource;
        LookupJavaField(jEnv, info, "publishedState", "Ltv/twitch/chat/ChatCommentPublishedState;"); // public tv.twitch.chat.ChatCommentPublishedState publishedState;
        LookupJavaField(jEnv, info, "moreReplies", "Z"); // public boolean moreReplies;
    }

    return info;
}
