/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatcommentmanagerproxy.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatCommentManagerProxy(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatCommentManagerProxy");

        LookupJavaMethod(jEnv, info, "<init>", "(JLtv/twitch/IJniThreadValidator;)V"); // public tv.twitch.chat.ChatCommentManagerProxy(long, tv.twitch.IJniThreadValidator);

        LookupJavaMethod(jEnv, info, "disposeNativeInstance", "(J)V"); // protected void disposeNativeInstance(long);
        LookupJavaMethod(jEnv, info, "dispose", "()V"); // public void dispose();
        LookupJavaMethod(jEnv, info, "play", "()Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode play();
        LookupJavaMethod(jEnv, info, "pause", "()Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode pause();
        LookupJavaMethod(jEnv, info, "updatePlayhead", "(I)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode updatePlayhead(int);
        LookupJavaMethod(jEnv, info, "getPlayheadTime", "()Ltv/twitch/Result;"); // public tv.twitch.Result<java.lang.Integer> getPlayheadTime();
        LookupJavaMethod(jEnv, info, "getChannelId", "()Ltv/twitch/Result;"); // public tv.twitch.Result<java.lang.Integer> getChannelId();
        LookupJavaMethod(jEnv, info, "getPlayingState", "()Ltv/twitch/Result;"); // public tv.twitch.Result<tv.twitch.chat.PlayingState> getPlayingState();
        LookupJavaMethod(jEnv, info, "fetchCommentsByTimestamp", "(IILtv/twitch/chat/IChatCommentManager$FetchCommentsCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode fetchCommentsByTimestamp(int, int, tv.twitch.chat.IChatCommentManager$FetchCommentsCallback);
        LookupJavaMethod(jEnv, info, "fetchCommentsByCursor", "(Ljava/lang/String;ILtv/twitch/chat/IChatCommentManager$FetchCommentsCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode fetchCommentsByCursor(java.lang.String, int, tv.twitch.chat.IChatCommentManager$FetchCommentsCallback);
        LookupJavaMethod(jEnv, info, "fetchComment", "(Ljava/lang/String;Ltv/twitch/chat/IChatCommentManager$FetchCommentCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode fetchComment(java.lang.String, tv.twitch.chat.IChatCommentManager$FetchCommentCallback);
        LookupJavaMethod(jEnv, info, "deleteComment", "(Ljava/lang/String;Ltv/twitch/chat/IChatCommentManager$DeleteCommentCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode deleteComment(java.lang.String, tv.twitch.chat.IChatCommentManager$DeleteCommentCallback);
        LookupJavaMethod(jEnv, info, "postComment", "(Ljava/lang/String;ILtv/twitch/chat/IChatCommentManager$PostCommentCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode postComment(java.lang.String, int, tv.twitch.chat.IChatCommentManager$PostCommentCallback);
        LookupJavaMethod(jEnv, info, "reportComment", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ltv/twitch/chat/IChatCommentManager$ReportCommentCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode reportComment(java.lang.String, java.lang.String, java.lang.String, tv.twitch.chat.IChatCommentManager$ReportCommentCallback);
        LookupJavaMethod(jEnv, info, "fetchCommentReplies", "(Ljava/lang/String;Ltv/twitch/chat/IChatCommentManager$FetchCommentRepliesCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode fetchCommentReplies(java.lang.String, tv.twitch.chat.IChatCommentManager$FetchCommentRepliesCallback);
        LookupJavaMethod(jEnv, info, "postCommentReply", "(Ljava/lang/String;Ljava/lang/String;Ltv/twitch/chat/IChatCommentManager$PostCommentReplyCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode postCommentReply(java.lang.String, java.lang.String, tv.twitch.chat.IChatCommentManager$PostCommentReplyCallback);
    }

    return info;
}
