/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatfirsttimechatternotice.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatFirstTimeChatterNotice(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatFirstTimeChatterNotice");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatFirstTimeChatterNotice();

        LookupJavaField(jEnv, info, "userMessage", "Ltv/twitch/chat/ChatMessageInfo;"); // public tv.twitch.chat.ChatMessageInfo userMessage;
        LookupJavaField(jEnv, info, "systemMessage", "Ljava/lang/String;"); // public java.lang.String systemMessage;
        LookupJavaField(jEnv, info, "messageId", "Ljava/lang/String;"); // public java.lang.String messageId;
    }

    return info;
}
