/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatmessageflags.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatMessageFlags(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatMessageFlags");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatMessageFlags();

        LookupJavaField(jEnv, info, "action", "Z"); // public boolean action;
        LookupJavaField(jEnv, info, "notice", "Z"); // public boolean notice;
        LookupJavaField(jEnv, info, "ignored", "Z"); // public boolean ignored;
        LookupJavaField(jEnv, info, "deleted", "Z"); // public boolean deleted;
        LookupJavaField(jEnv, info, "containsBits", "Z"); // public boolean containsBits;
    }

    return info;
}
