/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatmessagehandler_icallbacks.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatMessageHandler_ICallbacks(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatMessageHandler$ICallbacks");

        LookupJavaMethod(jEnv, info, "passThrough", "(Ljava/lang/String;)Z"); // public abstract boolean passThrough(java.lang.String);
        LookupJavaMethod(jEnv, info, "blockUser", "(Ljava/lang/String;)Z"); // public abstract boolean blockUser(java.lang.String);
        LookupJavaMethod(jEnv, info, "unblockUser", "(Ljava/lang/String;)Z"); // public abstract boolean unblockUser(java.lang.String);
        LookupJavaMethod(jEnv, info, "whisperUser", "(Ljava/lang/String;Ljava/lang/String;)Z"); // public abstract boolean whisperUser(java.lang.String, java.lang.String);
        LookupJavaMethod(jEnv, info, "createRaid", "(Ljava/lang/String;)Z"); // public abstract boolean createRaid(java.lang.String);
        LookupJavaMethod(jEnv, info, "cancelRaid", "()Z"); // public abstract boolean cancelRaid();
        LookupJavaMethod(jEnv, info, "grantVIP", "(Ljava/lang/String;)Z"); // public abstract boolean grantVIP(java.lang.String);
        LookupJavaMethod(jEnv, info, "revokeVIP", "(Ljava/lang/String;)Z"); // public abstract boolean revokeVIP(java.lang.String);
        LookupJavaMethod(jEnv, info, "listVIPs", "()Z"); // public abstract boolean listVIPs();
    }

    return info;
}
