/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatmessageinfo.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatMessageInfo(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatMessageInfo");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatMessageInfo();

        LookupJavaMethod(jEnv, info, "dateFromTimestamp", "()Ljava/util/Date;"); // public java.util.Date dateFromTimestamp();

        LookupJavaField(jEnv, info, "userName", "Ljava/lang/String;"); // public java.lang.String userName;
        LookupJavaField(jEnv, info, "displayName", "Ljava/lang/String;"); // public java.lang.String displayName;
        LookupJavaField(jEnv, info, "userId", "I"); // public int userId;
        LookupJavaField(jEnv, info, "userMode", "Ltv/twitch/chat/ChatUserMode;"); // public tv.twitch.chat.ChatUserMode userMode;
        LookupJavaField(jEnv, info, "nameColorARGB", "I"); // public int nameColorARGB;
        LookupJavaField(jEnv, info, "flags", "Ltv/twitch/chat/ChatMessageFlags;"); // public tv.twitch.chat.ChatMessageFlags flags;
        LookupJavaField(jEnv, info, "timestamp", "I"); // public int timestamp;
        LookupJavaField(jEnv, info, "numBitsSent", "I"); // public int numBitsSent;
        LookupJavaField(jEnv, info, "tokens", "[Ltv/twitch/chat/ChatMessageToken;"); // public tv.twitch.chat.ChatMessageToken[] tokens;
        LookupJavaField(jEnv, info, "badges", "[Ltv/twitch/chat/ChatMessageBadge;"); // public tv.twitch.chat.ChatMessageBadge[] badges;
        LookupJavaField(jEnv, info, "messageType", "Ljava/lang/String;"); // public java.lang.String messageType;
        LookupJavaField(jEnv, info, "messageTags", "Ljava/util/HashMap;"); // public java.util.HashMap<java.lang.String, java.lang.String> messageTags;
    }

    return info;
}
