/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatraidnotice.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatRaidNotice(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatRaidNotice");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatRaidNotice();

        LookupJavaField(jEnv, info, "systemMessage", "Ljava/lang/String;"); // public java.lang.String systemMessage;
        LookupJavaField(jEnv, info, "profileImageUrl", "Ljava/lang/String;"); // public java.lang.String profileImageUrl;
        LookupJavaField(jEnv, info, "raidingUserInfo", "Ltv/twitch/UserInfo;"); // public tv.twitch.UserInfo raidingUserInfo;
        LookupJavaField(jEnv, info, "viewerCount", "I"); // public int viewerCount;
    }

    return info;
}
