/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatraidproxy.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatRaidProxy(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatRaidProxy");

        LookupJavaMethod(jEnv, info, "<init>", "(JLtv/twitch/IJniThreadValidator;)V"); // public tv.twitch.chat.ChatRaidProxy(long, tv.twitch.IJniThreadValidator);

        LookupJavaMethod(jEnv, info, "disposeNativeInstance", "(J)V"); // protected void disposeNativeInstance(long);
        LookupJavaMethod(jEnv, info, "join", "(Ljava/lang/String;Ltv/twitch/chat/IChatRaid$JoinCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode join(java.lang.String, tv.twitch.chat.IChatRaid$JoinCallback);
        LookupJavaMethod(jEnv, info, "leave", "(Ljava/lang/String;Ltv/twitch/chat/IChatRaid$LeaveCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode leave(java.lang.String, tv.twitch.chat.IChatRaid$LeaveCallback);
        LookupJavaMethod(jEnv, info, "start", "(ILtv/twitch/chat/IChatRaid$StartCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode start(int, tv.twitch.chat.IChatRaid$StartCallback);
        LookupJavaMethod(jEnv, info, "raidNow", "(Ltv/twitch/chat/IChatRaid$RaidNowCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode raidNow(tv.twitch.chat.IChatRaid$RaidNowCallback);
        LookupJavaMethod(jEnv, info, "cancel", "(Ltv/twitch/chat/IChatRaid$CancelCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode cancel(tv.twitch.chat.IChatRaid$CancelCallback);
    }

    return info;
}
