/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatraidstatus.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatRaidStatus(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatRaidStatus");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatRaidStatus();

        LookupJavaField(jEnv, info, "raidId", "Ljava/lang/String;"); // public java.lang.String raidId;
        LookupJavaField(jEnv, info, "targetUserLogin", "Ljava/lang/String;"); // public java.lang.String targetUserLogin;
        LookupJavaField(jEnv, info, "targetUserDisplayName", "Ljava/lang/String;"); // public java.lang.String targetUserDisplayName;
        LookupJavaField(jEnv, info, "targetUserProfileImageUrl", "Ljava/lang/String;"); // public java.lang.String targetUserProfileImageUrl;
        LookupJavaField(jEnv, info, "creatorUserId", "I"); // public int creatorUserId;
        LookupJavaField(jEnv, info, "sourceChannelId", "I"); // public int sourceChannelId;
        LookupJavaField(jEnv, info, "targetChannelId", "I"); // public int targetChannelId;
        LookupJavaField(jEnv, info, "numUsersInRaid", "I"); // public int numUsersInRaid;
        LookupJavaField(jEnv, info, "transitionJitterSeconds", "I"); // public int transitionJitterSeconds;
        LookupJavaField(jEnv, info, "forceRaidNowSeconds", "I"); // public int forceRaidNowSeconds;
        LookupJavaField(jEnv, info, "joined", "Z"); // public boolean joined;
    }

    return info;
}
