/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatrestrictionreason.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatRestrictionReason(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatRestrictionReason");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatRestrictionReason();

        LookupJavaField(jEnv, info, "anonymous", "Z"); // public boolean anonymous;
        LookupJavaField(jEnv, info, "subscribersOnly", "Z"); // public boolean subscribersOnly;
        LookupJavaField(jEnv, info, "slowMode", "Z"); // public boolean slowMode;
        LookupJavaField(jEnv, info, "timeout", "Z"); // public boolean timeout;
        LookupJavaField(jEnv, info, "banned", "Z"); // public boolean banned;
    }

    return info;
}
