/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatroominfo.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatRoomInfo(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatRoomInfo");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatRoomInfo();

        LookupJavaField(jEnv, info, "owner", "Ltv/twitch/UserInfo;"); // public tv.twitch.UserInfo owner;
        LookupJavaField(jEnv, info, "view", "Ltv/twitch/chat/ChatRoomView;"); // public tv.twitch.chat.ChatRoomView view;
        LookupJavaField(jEnv, info, "modes", "Ltv/twitch/chat/ChatModeInfo;"); // public tv.twitch.chat.ChatModeInfo modes;
        LookupJavaField(jEnv, info, "id", "Ljava/lang/String;"); // public java.lang.String id;
        LookupJavaField(jEnv, info, "name", "Ljava/lang/String;"); // public java.lang.String name;
        LookupJavaField(jEnv, info, "topic", "Ljava/lang/String;"); // public java.lang.String topic;
        LookupJavaField(jEnv, info, "rolePermissions", "Ltv/twitch/chat/RoomRolePermissions;"); // public tv.twitch.chat.RoomRolePermissions rolePermissions;
    }

    return info;
}
