/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatroommessagehandler_icallbacks.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatRoomMessageHandler_ICallbacks(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatRoomMessageHandler$ICallbacks");

        LookupJavaMethod(jEnv, info, "passThrough", "(Ljava/lang/String;)Z"); // public abstract boolean passThrough(java.lang.String);
        LookupJavaMethod(jEnv, info, "banUser", "(Ljava/lang/String;)Z"); // public abstract boolean banUser(java.lang.String);
        LookupJavaMethod(jEnv, info, "timeoutUser", "(Ljava/lang/String;I)Z"); // public abstract boolean timeoutUser(java.lang.String, int);
        LookupJavaMethod(jEnv, info, "setUserColor", "(Ljava/lang/String;)Z"); // public abstract boolean setUserColor(java.lang.String);
        LookupJavaMethod(jEnv, info, "help", "()Z"); // public abstract boolean help();
        LookupJavaMethod(jEnv, info, "listRooms", "()Z"); // public abstract boolean listRooms();
        LookupJavaMethod(jEnv, info, "modUser", "(Ljava/lang/String;)Z"); // public abstract boolean modUser(java.lang.String);
        LookupJavaMethod(jEnv, info, "listModerators", "()Z"); // public abstract boolean listModerators();
        LookupJavaMethod(jEnv, info, "setTopic", "(Ljava/lang/String;)Z"); // public abstract boolean setTopic(java.lang.String);
        LookupJavaMethod(jEnv, info, "unbanUser", "(Ljava/lang/String;)Z"); // public abstract boolean unbanUser(java.lang.String);
        LookupJavaMethod(jEnv, info, "unmodUser", "(Ljava/lang/String;)Z"); // public abstract boolean unmodUser(java.lang.String);
        LookupJavaMethod(jEnv, info, "untimeoutUser", "(Ljava/lang/String;)Z"); // public abstract boolean untimeoutUser(java.lang.String);
        LookupJavaMethod(jEnv, info, "blockUser", "(Ljava/lang/String;)Z"); // public abstract boolean blockUser(java.lang.String);
        LookupJavaMethod(jEnv, info, "unblockUser", "(Ljava/lang/String;)Z"); // public abstract boolean unblockUser(java.lang.String);
        LookupJavaMethod(jEnv, info, "slowMode", "(ZI)Z"); // public abstract boolean slowMode(boolean, int);
        LookupJavaMethod(jEnv, info, "r9kMode", "(Z)Z"); // public abstract boolean r9kMode(boolean);
        LookupJavaMethod(jEnv, info, "emotesOnlyMode", "(Z)Z"); // public abstract boolean emotesOnlyMode(boolean);
        LookupJavaMethod(jEnv, info, "malformedCommand", "(Ltv/twitch/chat/ChatRoomMessageHandler$CommandError;Ljava/lang/String;)Z"); // public abstract boolean malformedCommand(tv.twitch.chat.ChatRoomMessageHandler$CommandError, java.lang.String);
    }

    return info;
}
