/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatroomview.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatRoomView(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatRoomView");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatRoomView();

        LookupJavaField(jEnv, info, "lastReadAt", "I"); // public int lastReadAt;
        LookupJavaField(jEnv, info, "unreadMentionCount", "I"); // public int unreadMentionCount;
        LookupJavaField(jEnv, info, "permissions", "Ltv/twitch/chat/ChatRoomPermissions;"); // public tv.twitch.chat.ChatRoomPermissions permissions;
        LookupJavaField(jEnv, info, "isMuted", "Z"); // public boolean isMuted;
        LookupJavaField(jEnv, info, "isArchived", "Z"); // public boolean isArchived;
        LookupJavaField(jEnv, info, "isUnread", "Z"); // public boolean isUnread;
    }

    return info;
}
