/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatsubscriberaddedevent.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatSubscriberAddedEvent(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatSubscriberAddedEvent");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatSubscriberAddedEvent();

        LookupJavaField(jEnv, info, "subNotice", "Ltv/twitch/chat/ChatSubscriptionNotice;"); // public tv.twitch.chat.ChatSubscriptionNotice subNotice;
        LookupJavaField(jEnv, info, "userName", "Ljava/lang/String;"); // public java.lang.String userName;
        LookupJavaField(jEnv, info, "displayName", "Ljava/lang/String;"); // public java.lang.String displayName;
        LookupJavaField(jEnv, info, "channelName", "Ljava/lang/String;"); // public java.lang.String channelName;
        LookupJavaField(jEnv, info, "userId", "I"); // public int userId;
        LookupJavaField(jEnv, info, "channelId", "I"); // public int channelId;
        LookupJavaField(jEnv, info, "timestamp", "I"); // public int timestamp;
    }

    return info;
}
