/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatsubscriptionnotice.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatSubscriptionNotice(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatSubscriptionNotice");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatSubscriptionNotice();

        LookupJavaField(jEnv, info, "userMessage", "Ltv/twitch/chat/ChatMessageInfo;"); // public tv.twitch.chat.ChatMessageInfo userMessage;
        LookupJavaField(jEnv, info, "systemMessage", "Ljava/lang/String;"); // public java.lang.String systemMessage;
        LookupJavaField(jEnv, info, "subStreakMonthCount", "I"); // public int subStreakMonthCount;
        LookupJavaField(jEnv, info, "subCumulativeMonthCount", "I"); // public int subCumulativeMonthCount;
        LookupJavaField(jEnv, info, "senderCount", "I"); // public int senderCount;
        LookupJavaField(jEnv, info, "massGiftCount", "I"); // public int massGiftCount;
        LookupJavaField(jEnv, info, "benefitEndMonth", "I"); // public int benefitEndMonth;
        LookupJavaField(jEnv, info, "type", "Ltv/twitch/chat/ChatSubscriptionNoticeType;"); // public tv.twitch.chat.ChatSubscriptionNoticeType type;
        LookupJavaField(jEnv, info, "plan", "Ltv/twitch/chat/ChatSubscriptionNoticePlan;"); // public tv.twitch.chat.ChatSubscriptionNoticePlan plan;
        LookupJavaField(jEnv, info, "recipient", "Ltv/twitch/chat/ChatSubscriptionNoticeRecipient;"); // public tv.twitch.chat.ChatSubscriptionNoticeRecipient recipient;
        LookupJavaField(jEnv, info, "planDisplayName", "Ljava/lang/String;"); // public java.lang.String planDisplayName;
        LookupJavaField(jEnv, info, "messageId", "Ljava/lang/String;"); // public java.lang.String messageId;
        LookupJavaField(jEnv, info, "shouldShowSubStreak", "Z"); // public boolean shouldShowSubStreak;
    }

    return info;
}
