/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chattexttoken.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatTextToken(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatTextToken");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatTextToken();

        LookupJavaField(jEnv, info, "text", "Ljava/lang/String;"); // public java.lang.String text;
        LookupJavaField(jEnv, info, "autoModFlags", "Ltv/twitch/chat/AutoModFlags;"); // public tv.twitch.chat.AutoModFlags autoModFlags;
    }

    return info;
}
