/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chattokenizationoptions.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatTokenizationOptions(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatTokenizationOptions");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatTokenizationOptions();

        LookupJavaField(jEnv, info, "emoticons", "Z"); // public boolean emoticons;
        LookupJavaField(jEnv, info, "mentions", "Z"); // public boolean mentions;
        LookupJavaField(jEnv, info, "urls", "Z"); // public boolean urls;
        LookupJavaField(jEnv, info, "bits", "Z"); // public boolean bits;
    }

    return info;
}
