/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatuserinfo.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatUserInfo(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatUserInfo");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatUserInfo();

        LookupJavaMethod(jEnv, info, "copy", "()Ltv/twitch/chat/ChatUserInfo;"); // public tv.twitch.chat.ChatUserInfo copy();
        LookupJavaMethod(jEnv, info, "toString", "()Ljava/lang/String;"); // public java.lang.String toString();
        LookupJavaMethod(jEnv, info, "equals", "(Ljava/lang/Object;)Z"); // public boolean equals(java.lang.Object);

        LookupJavaField(jEnv, info, "userName", "Ljava/lang/String;"); // public java.lang.String userName;
        LookupJavaField(jEnv, info, "displayName", "Ljava/lang/String;"); // public java.lang.String displayName;
        LookupJavaField(jEnv, info, "userMode", "Ltv/twitch/chat/ChatUserMode;"); // public tv.twitch.chat.ChatUserMode userMode;
        LookupJavaField(jEnv, info, "nameColorARGB", "I"); // public int nameColorARGB;
        LookupJavaField(jEnv, info, "userId", "I"); // public int userId;
    }

    return info;
}
