/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatusermode.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatUserMode(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatUserMode");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatUserMode();

        LookupJavaField(jEnv, info, "moderator", "Z"); // public boolean moderator;
        LookupJavaField(jEnv, info, "broadcaster", "Z"); // public boolean broadcaster;
        LookupJavaField(jEnv, info, "administrator", "Z"); // public boolean administrator;
        LookupJavaField(jEnv, info, "staff", "Z"); // public boolean staff;
        LookupJavaField(jEnv, info, "system", "Z"); // public boolean system;
        LookupJavaField(jEnv, info, "globalModerator", "Z"); // public boolean globalModerator;
        LookupJavaField(jEnv, info, "banned", "Z"); // public boolean banned;
        LookupJavaField(jEnv, info, "subscriber", "Z"); // public boolean subscriber;
        LookupJavaField(jEnv, info, "vip", "Z"); // public boolean vip;
    }

    return info;
}
