/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_createroomerror.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_CreateRoomError(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/CreateRoomError");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.CreateRoomError();

        LookupJavaField(jEnv, info, "code", "Ltv/twitch/chat/ChatGraphQLErrorCode;"); // public tv.twitch.chat.ChatGraphQLErrorCode code;
        LookupJavaField(jEnv, info, "maxAllowedRooms", "I"); // public int maxAllowedRooms;
        LookupJavaField(jEnv, info, "minLength", "I"); // public int minLength;
        LookupJavaField(jEnv, info, "maxLength", "I"); // public int maxLength;
    }

    return info;
}
