/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_extensionmessage.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ExtensionMessage(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ExtensionMessage");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ExtensionMessage();

        LookupJavaField(jEnv, info, "tokens", "[Ltv/twitch/chat/ChatMessageToken;"); // public tv.twitch.chat.ChatMessageToken[] tokens;
        LookupJavaField(jEnv, info, "badges", "[Ltv/twitch/chat/ChatMessageBadge;"); // public tv.twitch.chat.ChatMessageBadge[] badges;
        LookupJavaField(jEnv, info, "messageId", "Ljava/lang/String;"); // public java.lang.String messageId;
        LookupJavaField(jEnv, info, "extensionClientId", "Ljava/lang/String;"); // public java.lang.String extensionClientId;
        LookupJavaField(jEnv, info, "extensionVersion", "Ljava/lang/String;"); // public java.lang.String extensionVersion;
        LookupJavaField(jEnv, info, "extensionDisplayName", "Ljava/lang/String;"); // public java.lang.String extensionDisplayName;
        LookupJavaField(jEnv, info, "chatColor", "I"); // public int chatColor;
        LookupJavaField(jEnv, info, "sentAt", "I"); // public int sentAt;
    }

    return info;
}
