/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ibitslistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IBitsListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IBitsListener");

        LookupJavaMethod(jEnv, info, "userReceivedBits", "(Ltv/twitch/chat/ChatBitsReceivedEvent;)V"); // public abstract void userReceivedBits(tv.twitch.chat.ChatBitsReceivedEvent);
        LookupJavaMethod(jEnv, info, "userSentBits", "(Ltv/twitch/chat/ChatBitsSentEvent;)V"); // public abstract void userSentBits(tv.twitch.chat.ChatBitsSentEvent);
        LookupJavaMethod(jEnv, info, "userGainedBits", "(I)V"); // public abstract void userGainedBits(int);
    }

    return info;
}
