/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ichannelchatroommanager.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChannelChatRoomManager(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IChannelChatRoomManager");

        LookupJavaMethod(jEnv, info, "dispose", "()V"); // public abstract void dispose();
        LookupJavaMethod(jEnv, info, "addNewChatRoom", "(Ljava/lang/String;Ljava/lang/String;Ltv/twitch/chat/RoomRolePermissions;Ltv/twitch/chat/IChannelChatRoomManager$AddRoomCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode addNewChatRoom(java.lang.String, java.lang.String, tv.twitch.chat.RoomRolePermissions, tv.twitch.chat.IChannelChatRoomManager$AddRoomCallback);
        LookupJavaMethod(jEnv, info, "joinChatRooms", "(Ltv/twitch/chat/IChannelChatRoomManager$JoinCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode joinChatRooms(tv.twitch.chat.IChannelChatRoomManager$JoinCallback);
        LookupJavaMethod(jEnv, info, "leaveChatRooms", "(Ltv/twitch/chat/IChannelChatRoomManager$LeaveCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode leaveChatRooms(tv.twitch.chat.IChannelChatRoomManager$LeaveCallback);
        LookupJavaMethod(jEnv, info, "fetchChatRoomsInfo", "(Ltv/twitch/chat/IChannelChatRoomManager$FetchRoomsInfoCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode fetchChatRoomsInfo(tv.twitch.chat.IChannelChatRoomManager$FetchRoomsInfoCallback);
    }

    return info;
}
