/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ichannelchatroommanagerlistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChannelChatRoomManagerListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IChannelChatRoomManagerListener");

        LookupJavaMethod(jEnv, info, "purgeMessages", "(III)V"); // public abstract void purgeMessages(int, int, int);
        LookupJavaMethod(jEnv, info, "roomCreated", "(ILtv/twitch/chat/ChatRoomInfo;)V"); // public abstract void roomCreated(int, tv.twitch.chat.ChatRoomInfo);
        LookupJavaMethod(jEnv, info, "roomDeleted", "(ILtv/twitch/chat/ChatRoomInfo;)V"); // public abstract void roomDeleted(int, tv.twitch.chat.ChatRoomInfo);
    }

    return info;
}
