/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ichatchannellistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChatChannelListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IChatChannelListener");

        LookupJavaMethod(jEnv, info, "chatChannelStateChanged", "(IILtv/twitch/chat/ChatChannelState;Ltv/twitch/ErrorCode;)V"); // public abstract void chatChannelStateChanged(int, int, tv.twitch.chat.ChatChannelState, tv.twitch.ErrorCode);
        LookupJavaMethod(jEnv, info, "chatChannelInfoChanged", "(IILtv/twitch/chat/ChatChannelInfo;)V"); // public abstract void chatChannelInfoChanged(int, int, tv.twitch.chat.ChatChannelInfo);
        LookupJavaMethod(jEnv, info, "chatChannelRestrictionsChanged", "(IILtv/twitch/chat/ChatChannelRestrictions;)V"); // public abstract void chatChannelRestrictionsChanged(int, int, tv.twitch.chat.ChatChannelRestrictions);
        LookupJavaMethod(jEnv, info, "chatChannelLocalUserChanged", "(IILtv/twitch/chat/ChatUserInfo;)V"); // public abstract void chatChannelLocalUserChanged(int, int, tv.twitch.chat.ChatUserInfo);
        LookupJavaMethod(jEnv, info, "chatChannelMessagesReceived", "(II[Ltv/twitch/chat/ChatLiveMessage;)V"); // public abstract void chatChannelMessagesReceived(int, int, tv.twitch.chat.ChatLiveMessage[]);
        LookupJavaMethod(jEnv, info, "chatChannelSubscriptionNoticeReceived", "(IILtv/twitch/chat/ChatSubscriptionNotice;)V"); // public abstract void chatChannelSubscriptionNoticeReceived(int, int, tv.twitch.chat.ChatSubscriptionNotice);
        LookupJavaMethod(jEnv, info, "chatChannelFirstTimeChatterNoticeReceived", "(IILtv/twitch/chat/ChatFirstTimeChatterNotice;)V"); // public abstract void chatChannelFirstTimeChatterNoticeReceived(int, int, tv.twitch.chat.ChatFirstTimeChatterNotice);
        LookupJavaMethod(jEnv, info, "chatChannelRaidNoticeReceived", "(IILtv/twitch/chat/ChatRaidNotice;)V"); // public abstract void chatChannelRaidNoticeReceived(int, int, tv.twitch.chat.ChatRaidNotice);
        LookupJavaMethod(jEnv, info, "chatChannelUnraidNoticeReceived", "(IILtv/twitch/chat/ChatUnraidNotice;)V"); // public abstract void chatChannelUnraidNoticeReceived(int, int, tv.twitch.chat.ChatUnraidNotice);
        LookupJavaMethod(jEnv, info, "chatChannelGenericNoticeReceived", "(IILtv/twitch/chat/ChatGenericMessageNotice;)V"); // public abstract void chatChannelGenericNoticeReceived(int, int, tv.twitch.chat.ChatGenericMessageNotice);
        LookupJavaMethod(jEnv, info, "chatChannelMessagesCleared", "(II)V"); // public abstract void chatChannelMessagesCleared(int, int);
        LookupJavaMethod(jEnv, info, "chatChannelUserMessagesCleared", "(III)V"); // public abstract void chatChannelUserMessagesCleared(int, int, int);
        LookupJavaMethod(jEnv, info, "chatChannelMessageDeleted", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"); // public abstract void chatChannelMessageDeleted(int, int, java.lang.String, java.lang.String, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeUserTimedOut", "(IILtv/twitch/chat/ModerationActionInfo;ILjava/lang/String;)V"); // public abstract void chatChannelModNoticeUserTimedOut(int, int, tv.twitch.chat.ModerationActionInfo, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeUserBanned", "(IILtv/twitch/chat/ModerationActionInfo;Ljava/lang/String;)V"); // public abstract void chatChannelModNoticeUserBanned(int, int, tv.twitch.chat.ModerationActionInfo, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeUserUntimedOut", "(IILtv/twitch/chat/ModerationActionInfo;)V"); // public abstract void chatChannelModNoticeUserUntimedOut(int, int, tv.twitch.chat.ModerationActionInfo);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeUserUnbanned", "(IILtv/twitch/chat/ModerationActionInfo;)V"); // public abstract void chatChannelModNoticeUserUnbanned(int, int, tv.twitch.chat.ModerationActionInfo);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeMessageDeleted", "(IILtv/twitch/chat/ModerationActionInfo;Ljava/lang/String;Ljava/lang/String;)V"); // public abstract void chatChannelModNoticeMessageDeleted(int, int, tv.twitch.chat.ModerationActionInfo, java.lang.String, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeClearChat", "(IIILjava/lang/String;)V"); // public abstract void chatChannelModNoticeClearChat(int, int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeEmoteOnly", "(IIILjava/lang/String;)V"); // public abstract void chatChannelModNoticeEmoteOnly(int, int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeEmoteOnlyOff", "(IIILjava/lang/String;)V"); // public abstract void chatChannelModNoticeEmoteOnlyOff(int, int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeFollowersOnly", "(IIILjava/lang/String;I)V"); // public abstract void chatChannelModNoticeFollowersOnly(int, int, int, java.lang.String, int);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeFollowersOnlyOff", "(IIILjava/lang/String;)V"); // public abstract void chatChannelModNoticeFollowersOnlyOff(int, int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeR9K", "(IIILjava/lang/String;)V"); // public abstract void chatChannelModNoticeR9K(int, int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeR9KOff", "(IIILjava/lang/String;)V"); // public abstract void chatChannelModNoticeR9KOff(int, int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeSlow", "(IIILjava/lang/String;I)V"); // public abstract void chatChannelModNoticeSlow(int, int, int, java.lang.String, int);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeSlowOff", "(IIILjava/lang/String;)V"); // public abstract void chatChannelModNoticeSlowOff(int, int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeSubsOnly", "(IIILjava/lang/String;)V"); // public abstract void chatChannelModNoticeSubsOnly(int, int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelModNoticeSubsOnlyOff", "(IIILjava/lang/String;)V"); // public abstract void chatChannelModNoticeSubsOnlyOff(int, int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "chatChannelHostTargetChanged", "(IILjava/lang/String;I)V"); // public abstract void chatChannelHostTargetChanged(int, int, java.lang.String, int);
        LookupJavaMethod(jEnv, info, "chatChannelNoticeReceived", "(IILjava/lang/String;Ljava/util/HashMap;)V"); // public abstract void chatChannelNoticeReceived(int, int, java.lang.String, java.util.HashMap<java.lang.String, java.lang.String>);
        LookupJavaMethod(jEnv, info, "autoModCaughtSentMessage", "(II)V"); // public abstract void autoModCaughtSentMessage(int, int);
        LookupJavaMethod(jEnv, info, "autoModDeniedSentMessage", "(II)V"); // public abstract void autoModDeniedSentMessage(int, int);
        LookupJavaMethod(jEnv, info, "autoModApprovedSentMessage", "(II)V"); // public abstract void autoModApprovedSentMessage(int, int);
        LookupJavaMethod(jEnv, info, "autoModCaughtMessageForMods", "(IILjava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V"); // public abstract void autoModCaughtMessageForMods(int, int, java.lang.String, java.lang.String, int, java.lang.String, java.lang.String);
        LookupJavaMethod(jEnv, info, "autoModMessageApprovedByMod", "(IILjava/lang/String;ILjava/lang/String;)V"); // public abstract void autoModMessageApprovedByMod(int, int, java.lang.String, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "autoModMessageDeniedByMod", "(IILjava/lang/String;ILjava/lang/String;)V"); // public abstract void autoModMessageDeniedByMod(int, int, java.lang.String, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "autoModDeniedSentCheer", "(II)V"); // public abstract void autoModDeniedSentCheer(int, int);
        LookupJavaMethod(jEnv, info, "autoModTimedOutSentCheer", "(II)V"); // public abstract void autoModTimedOutSentCheer(int, int);
        LookupJavaMethod(jEnv, info, "autoModCaughtCheerForMods", "(IILjava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V"); // public abstract void autoModCaughtCheerForMods(int, int, java.lang.String, java.lang.String, int, java.lang.String, java.lang.String);
    }

    return info;
}
