/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ichatchannelpropertylistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChatChannelPropertyListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IChatChannelPropertyListener");

        LookupJavaMethod(jEnv, info, "ritualsEnabled", "(Z)V"); // public abstract void ritualsEnabled(boolean);
        LookupJavaMethod(jEnv, info, "outgoingHostChanged", "(IIILjava/lang/String;I)V"); // public abstract void outgoingHostChanged(int, int, int, java.lang.String, int);
        LookupJavaMethod(jEnv, info, "incomingHostStarted", "(IILjava/lang/String;I)V"); // public abstract void incomingHostStarted(int, int, java.lang.String, int);
        LookupJavaMethod(jEnv, info, "incomingHostEnded", "(IILjava/lang/String;)V"); // public abstract void incomingHostEnded(int, int, java.lang.String);
        LookupJavaMethod(jEnv, info, "extensionMessageReceived", "(Ltv/twitch/chat/ExtensionMessage;)V"); // public abstract void extensionMessageReceived(tv.twitch.chat.ExtensionMessage);
        LookupJavaMethod(jEnv, info, "chatChannelRestrictionsReceived", "(Ltv/twitch/chat/ChatChannelRestrictions;)V"); // public abstract void chatChannelRestrictionsReceived(tv.twitch.chat.ChatChannelRestrictions);
    }

    return info;
}
