/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ichatcommentlistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChatCommentListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IChatCommentListener");

        LookupJavaMethod(jEnv, info, "chatCommentManagerStateChanged", "(ILjava/lang/String;Ltv/twitch/chat/PlayingState;)V"); // public abstract void chatCommentManagerStateChanged(int, java.lang.String, tv.twitch.chat.PlayingState);
        LookupJavaMethod(jEnv, info, "chatCommentsReceived", "(ILjava/lang/String;[Ltv/twitch/chat/ChatComment;)V"); // public abstract void chatCommentsReceived(int, java.lang.String, tv.twitch.chat.ChatComment[]);
        LookupJavaMethod(jEnv, info, "chatCommentsErrorReceived", "(Ljava/lang/String;I)V"); // public abstract void chatCommentsErrorReceived(java.lang.String, int);
    }

    return info;
}
