/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ichatraidlistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChatRaidListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IChatRaidListener");

        LookupJavaMethod(jEnv, info, "raidStarted", "(Ltv/twitch/chat/ChatRaidStatus;)V"); // public abstract void raidStarted(tv.twitch.chat.ChatRaidStatus);
        LookupJavaMethod(jEnv, info, "raidUpdated", "(Ltv/twitch/chat/ChatRaidStatus;)V"); // public abstract void raidUpdated(tv.twitch.chat.ChatRaidStatus);
        LookupJavaMethod(jEnv, info, "raidFired", "(Ltv/twitch/chat/ChatRaidStatus;)V"); // public abstract void raidFired(tv.twitch.chat.ChatRaidStatus);
        LookupJavaMethod(jEnv, info, "raidCancelled", "(Ltv/twitch/chat/ChatRaidStatus;)V"); // public abstract void raidCancelled(tv.twitch.chat.ChatRaidStatus);
    }

    return info;
}
