/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ichatroom.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChatRoom(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IChatRoom");

        LookupJavaMethod(jEnv, info, "dispose", "()V"); // public abstract void dispose();
        LookupJavaMethod(jEnv, info, "deleteRoom", "(Ltv/twitch/chat/IChatRoom$DeleteRoomCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode deleteRoom(tv.twitch.chat.IChatRoom$DeleteRoomCallback);
        LookupJavaMethod(jEnv, info, "sendMessage", "(Ljava/lang/String;Ltv/twitch/ResultContainer;Ltv/twitch/chat/IChatRoom$SendMessageCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode sendMessage(java.lang.String, tv.twitch.ResultContainer<tv.twitch.chat.ChatRoomMessage>, tv.twitch.chat.IChatRoom$SendMessageCallback);
        LookupJavaMethod(jEnv, info, "editMessage", "(Ljava/lang/String;Ljava/lang/String;Ltv/twitch/ResultContainer;Ltv/twitch/chat/IChatRoom$EditMessageCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode editMessage(java.lang.String, java.lang.String, tv.twitch.ResultContainer<tv.twitch.chat.ChatRoomMessage>, tv.twitch.chat.IChatRoom$EditMessageCallback);
        LookupJavaMethod(jEnv, info, "deleteMessage", "(Ljava/lang/String;Ltv/twitch/chat/IChatRoom$DeleteMessageCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode deleteMessage(java.lang.String, tv.twitch.chat.IChatRoom$DeleteMessageCallback);
        LookupJavaMethod(jEnv, info, "fetchMessagesBeforeCursor", "(Ljava/lang/String;ILtv/twitch/chat/IChatRoom$FetchMessagesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode fetchMessagesBeforeCursor(java.lang.String, int, tv.twitch.chat.IChatRoom$FetchMessagesCallback);
        LookupJavaMethod(jEnv, info, "fetchMessagesAfterCursor", "(Ljava/lang/String;ILtv/twitch/chat/IChatRoom$FetchMessagesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode fetchMessagesAfterCursor(java.lang.String, int, tv.twitch.chat.IChatRoom$FetchMessagesCallback);
        LookupJavaMethod(jEnv, info, "fetchMessagesBeforeTimestamp", "(IILtv/twitch/chat/IChatRoom$FetchMessagesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode fetchMessagesBeforeTimestamp(int, int, tv.twitch.chat.IChatRoom$FetchMessagesCallback);
        LookupJavaMethod(jEnv, info, "fetchMessagesAfterTimestamp", "(IILtv/twitch/chat/IChatRoom$FetchMessagesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode fetchMessagesAfterTimestamp(int, int, tv.twitch.chat.IChatRoom$FetchMessagesCallback);
        LookupJavaMethod(jEnv, info, "setRoomName", "(Ljava/lang/String;Ltv/twitch/chat/IChatRoom$UpdateRoomInfoCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode setRoomName(java.lang.String, tv.twitch.chat.IChatRoom$UpdateRoomInfoCallback);
        LookupJavaMethod(jEnv, info, "setTopic", "(Ljava/lang/String;Ltv/twitch/chat/IChatRoom$UpdateRoomInfoCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode setTopic(java.lang.String, tv.twitch.chat.IChatRoom$UpdateRoomInfoCallback);
        LookupJavaMethod(jEnv, info, "setRoomRolePermissions", "(Ltv/twitch/chat/RoomRolePermissions;Ltv/twitch/chat/IChatRoom$UpdateRoomInfoCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode setRoomRolePermissions(tv.twitch.chat.RoomRolePermissions, tv.twitch.chat.IChatRoom$UpdateRoomInfoCallback);
        LookupJavaMethod(jEnv, info, "enableSlowMode", "(ILtv/twitch/chat/IChatRoom$UpdateRoomModesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode enableSlowMode(int, tv.twitch.chat.IChatRoom$UpdateRoomModesCallback);
        LookupJavaMethod(jEnv, info, "disableSlowMode", "(Ltv/twitch/chat/IChatRoom$UpdateRoomModesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode disableSlowMode(tv.twitch.chat.IChatRoom$UpdateRoomModesCallback);
        LookupJavaMethod(jEnv, info, "enableR9kMode", "(Ltv/twitch/chat/IChatRoom$UpdateRoomModesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode enableR9kMode(tv.twitch.chat.IChatRoom$UpdateRoomModesCallback);
        LookupJavaMethod(jEnv, info, "disableR9kMode", "(Ltv/twitch/chat/IChatRoom$UpdateRoomModesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode disableR9kMode(tv.twitch.chat.IChatRoom$UpdateRoomModesCallback);
        LookupJavaMethod(jEnv, info, "enableEmotesOnlyMode", "(Ltv/twitch/chat/IChatRoom$UpdateRoomModesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode enableEmotesOnlyMode(tv.twitch.chat.IChatRoom$UpdateRoomModesCallback);
        LookupJavaMethod(jEnv, info, "disableEmotesOnlyMode", "(Ltv/twitch/chat/IChatRoom$UpdateRoomModesCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode disableEmotesOnlyMode(tv.twitch.chat.IChatRoom$UpdateRoomModesCallback);
        LookupJavaMethod(jEnv, info, "setLastReadAt", "(ILtv/twitch/chat/IChatRoom$UpdateRoomViewCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode setLastReadAt(int, tv.twitch.chat.IChatRoom$UpdateRoomViewCallback);
        LookupJavaMethod(jEnv, info, "setMuted", "(ZLtv/twitch/chat/IChatRoom$UpdateRoomViewCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode setMuted(boolean, tv.twitch.chat.IChatRoom$UpdateRoomViewCallback);
        LookupJavaMethod(jEnv, info, "setArchived", "(ZLtv/twitch/chat/IChatRoom$UpdateRoomViewCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode setArchived(boolean, tv.twitch.chat.IChatRoom$UpdateRoomViewCallback);
        LookupJavaMethod(jEnv, info, "fetchRoomInfo", "(Ltv/twitch/chat/IChatRoom$FetchRoomInfoCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode fetchRoomInfo(tv.twitch.chat.IChatRoom$FetchRoomInfoCallback);
    }

    return info;
}
