/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ichatroomlistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChatRoomListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IChatRoomListener");

        LookupJavaMethod(jEnv, info, "messageReceived", "(Ljava/lang/String;Ltv/twitch/chat/ChatRoomMessage;)V"); // public abstract void messageReceived(java.lang.String, tv.twitch.chat.ChatRoomMessage);
        LookupJavaMethod(jEnv, info, "messageEdited", "(Ljava/lang/String;Ltv/twitch/chat/ChatRoomMessage;)V"); // public abstract void messageEdited(java.lang.String, tv.twitch.chat.ChatRoomMessage);
        LookupJavaMethod(jEnv, info, "messageDeleted", "(Ljava/lang/String;Ltv/twitch/chat/ChatRoomMessage;)V"); // public abstract void messageDeleted(java.lang.String, tv.twitch.chat.ChatRoomMessage);
        LookupJavaMethod(jEnv, info, "roomUpdated", "(Ltv/twitch/chat/ChatRoomInfo;)V"); // public abstract void roomUpdated(tv.twitch.chat.ChatRoomInfo);
    }

    return info;
}
