/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_ichatroomnotificationslistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChatRoomNotificationsListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/IChatRoomNotificationsListener");

        LookupJavaMethod(jEnv, info, "userTimedOut", "(III)V"); // public abstract void userTimedOut(int, int, int);
        LookupJavaMethod(jEnv, info, "userBanned", "(II)V"); // public abstract void userBanned(int, int);
        LookupJavaMethod(jEnv, info, "userUnbanned", "(II)V"); // public abstract void userUnbanned(int, int);
        LookupJavaMethod(jEnv, info, "roomViewUpdated", "(IILjava/lang/String;Ltv/twitch/chat/ChatRoomView;)V"); // public abstract void roomViewUpdated(int, int, java.lang.String, tv.twitch.chat.ChatRoomView);
        LookupJavaMethod(jEnv, info, "roomMentionReceived", "(ILtv/twitch/chat/RoomMentionInfo;)V"); // public abstract void roomMentionReceived(int, tv.twitch.chat.RoomMentionInfo);
    }

    return info;
}
