/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_multiviewcontentattribute.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_MultiviewContentAttribute(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/MultiviewContentAttribute");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.MultiviewContentAttribute();

        LookupJavaField(jEnv, info, "attributeId", "Ljava/lang/String;"); // public java.lang.String attributeId;
        LookupJavaField(jEnv, info, "key", "Ljava/lang/String;"); // public java.lang.String key;
        LookupJavaField(jEnv, info, "name", "Ljava/lang/String;"); // public java.lang.String name;
        LookupJavaField(jEnv, info, "parentId", "Ljava/lang/String;"); // public java.lang.String parentId;
        LookupJavaField(jEnv, info, "parentKey", "Ljava/lang/String;"); // public java.lang.String parentKey;
        LookupJavaField(jEnv, info, "value", "Ljava/lang/String;"); // public java.lang.String value;
        LookupJavaField(jEnv, info, "valueShortName", "Ljava/lang/String;"); // public java.lang.String valueShortName;
        LookupJavaField(jEnv, info, "imageUrl", "Ljava/lang/String;"); // public java.lang.String imageUrl;
        LookupJavaField(jEnv, info, "ownerChannelId", "I"); // public int ownerChannelId;
        LookupJavaField(jEnv, info, "createdAt", "I"); // public int createdAt;
        LookupJavaField(jEnv, info, "updatedAt", "I"); // public int updatedAt;
    }

    return info;
}
