/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_roommentioninfo.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_RoomMentionInfo(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/RoomMentionInfo");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.RoomMentionInfo();

        LookupJavaField(jEnv, info, "roomOwnerName", "Ljava/lang/String;"); // public java.lang.String roomOwnerName;
        LookupJavaField(jEnv, info, "roomOwnerLogin", "Ljava/lang/String;"); // public java.lang.String roomOwnerLogin;
        LookupJavaField(jEnv, info, "senderName", "Ljava/lang/String;"); // public java.lang.String senderName;
        LookupJavaField(jEnv, info, "roomId", "Ljava/lang/String;"); // public java.lang.String roomId;
        LookupJavaField(jEnv, info, "roomName", "Ljava/lang/String;"); // public java.lang.String roomName;
        LookupJavaField(jEnv, info, "messageId", "Ljava/lang/String;"); // public java.lang.String messageId;
        LookupJavaField(jEnv, info, "roomOwnerId", "I"); // public int roomOwnerId;
        LookupJavaField(jEnv, info, "senderId", "I"); // public int senderId;
        LookupJavaField(jEnv, info, "sentAt", "I"); // public int sentAt;
    }

    return info;
}
