/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_roomrolepermissions.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_RoomRolePermissions(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/RoomRolePermissions");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.RoomRolePermissions();

        LookupJavaField(jEnv, info, "read", "Ltv/twitch/chat/RoomRole;"); // public tv.twitch.chat.RoomRole read;
        LookupJavaField(jEnv, info, "send", "Ltv/twitch/chat/RoomRole;"); // public tv.twitch.chat.RoomRole send;
    }

    return info;
}
