/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_bitslistenerproxy.h"

#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv::chat;

ttv::binding::java::JavaBitsListenerProxy::JavaBitsListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IBitsListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaBitsListenerProxy::UserReceivedBits(const BitsReceivedEvent& bitsReceivedEvent) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jBitsReceivedEvent,
    GetJavaInstance_ChatBitsReceivedEvent(gActiveJavaEnvironment, bitsReceivedEvent));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["userReceivedBits"], jBitsReceivedEvent);
}

void ttv::binding::java::JavaBitsListenerProxy::UserSentBits(const BitsSentEvent& bitsSentEvent) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jBitsSentEvent,
    GetJavaInstance_ChatBitsSentEvent(gActiveJavaEnvironment, bitsSentEvent));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["userSentBits"], jBitsSentEvent);
}

void ttv::binding::java::JavaBitsListenerProxy::UserGainedBits(const uint32_t bitsBalance) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["userGainedBits"], static_cast<jint>(bitsBalance));
}
