/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_chatapilistenerproxy.h"

#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv::chat;

ttv::binding::java::JavaChatAPIListenerProxy::JavaChatAPIListenerProxy(jobject jModule)
    : NativeModuleListener(jModule) {
  mListenerInfo = GetJavaClassInfo_IChatAPIListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaChatAPIListenerProxy::ChatUserEmoticonSetsChanged(
  UserId userId, const std::vector<EmoticonSet>& emoticonSets) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  auto& info = GetJavaClassInfo_ChatEmoticonSet(gActiveJavaEnvironment);
  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jEmoticonSets,
    GetJavaInstance_Array(
      gActiveJavaEnvironment, info, static_cast<jsize>(emoticonSets.size()), [&emoticonSets](uint32_t index) {
        return GetJavaInstance_ChatEmoticonSet(gActiveJavaEnvironment, emoticonSets[index]);
      }));
  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["chatUserEmoticonSetsChanged"], static_cast<jint>(userId), jEmoticonSets);
}
