/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/generated/java_chatmessagehandler.h"

#include "twitchsdk/chat/chatmessagehandler.h"
#include "twitchsdk/chat/java_chatmessagehandlercallbacksproxy.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;
using namespace ttv::binding::java;

JNIEXPORT jlong JNICALL Java_tv_twitch_chat_ChatMessageHandler_CreateNativeInstance(JNIEnv* jEnv, jobject jThis) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  // Force load all types to ensure all classes are loaded by the time we need them.
  LoadAllChatJavaClassInfo(jEnv);

  std::shared_ptr<ChatMessageHandlerContext> context = std::make_shared<ChatMessageHandlerContext>();

  context->chatMessageHandler = std::make_shared<ChatMessageHandler>();
  context->callbacks = std::make_shared<JavaChatMessageHandlerCallbacksProxy>();

  gChatMessageHandlerRegistry.Register(context->chatMessageHandler, context, jThis);
  context->chatMessageHandler->SetCallbacks(context->callbacks);

  return reinterpret_cast<jlong>(context->chatMessageHandler.get());
}

JNIEXPORT void JNICALL Java_tv_twitch_chat_ChatMessageHandler_DisposeNativeInstance(
  JNIEnv* /*jEnv*/, jobject /*jThis*/, jlong jNativePointer) {
  gChatMessageHandlerRegistry.Unregister(jNativePointer);
}

JNIEXPORT void JNICALL Java_tv_twitch_chat_ChatMessageHandler_SetCallbacks(
  JNIEnv* jEnv, jobject /*jThis*/, jlong jNativePointer, jobject jICallbacks) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  auto context = gChatMessageHandlerRegistry.LookupNativeContext(jNativePointer);
  if (context != nullptr) {
    std::shared_ptr<JavaChatMessageHandlerCallbacksProxy> callbacksProxy;

    auto& callbacks = context->callbacks;
    if (callbacks != nullptr) {
      callbacksProxy = callbacks;
    }

    if (jICallbacks != nullptr) {
      if (callbacksProxy == nullptr) {
        callbacksProxy = std::make_shared<JavaChatMessageHandlerCallbacksProxy>();
      }

      context->chatMessageHandler->SetCallbacks(callbacksProxy);
      callbacksProxy->SetListener(jICallbacks);
    }
  }
}

JNIEXPORT jboolean JNICALL Java_tv_twitch_chat_ChatMessageHandler_HandleMessage(
  JNIEnv* jEnv, jobject /*jThis*/, jlong jNativePointer, jstring jMessage) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  auto context = gChatMessageHandlerRegistry.LookupNativeContext(jNativePointer);
  if (context != nullptr) {
    ScopedJavaUTFStringConverter message(jEnv, jMessage);
    bool result = context->chatMessageHandler->HandleMessage(message.GetNativeString());

    return result ? JNI_TRUE : JNI_FALSE;
  }

  return JNI_FALSE;
}
