/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_chatmessagehandlercallbacksproxy.h"

#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;

ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::JavaChatMessageHandlerCallbacksProxy() {
  mListenerInfo = GetJavaClassInfo_ChatMessageHandler_ICallbacks(gActiveJavaEnvironment);
}

bool ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::PassThrough(const std::string& message) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jMessage, GetJavaInstance_String(gActiveJavaEnvironment, message));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["passThrough"], jMessage) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::BlockUser(const std::string& blockUserName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jBlockUserName, GetJavaInstance_String(gActiveJavaEnvironment, blockUserName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["blockUser"], jBlockUserName) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::UnblockUser(const std::string& unblockUserName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUnblockUserName, GetJavaInstance_String(gActiveJavaEnvironment, unblockUserName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["unblockUser"], jUnblockUserName) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::WhisperUser(
  const std::string& whisperUserName, const std::string& message) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jWhisperUserName, GetJavaInstance_String(gActiveJavaEnvironment, whisperUserName));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jMessage, GetJavaInstance_String(gActiveJavaEnvironment, message));

  return gActiveJavaEnvironment->CallBooleanMethod(
           jListener, mListenerInfo.methods["whisperUser"], jWhisperUserName, jMessage) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::CreateRaid(const std::string& raidTargetUserName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jRaidTargetUserName,
    GetJavaInstance_String(gActiveJavaEnvironment, raidTargetUserName));

  return gActiveJavaEnvironment->CallBooleanMethod(
           jListener, mListenerInfo.methods["createRaid"], jRaidTargetUserName) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::CancelRaid() {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["cancelRaid"]) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::GrantVIP(const std::string& vipUserName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jVipUserName, GetJavaInstance_String(gActiveJavaEnvironment, vipUserName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["grantVIP"], jVipUserName) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::RevokeVIP(const std::string& unvipUserName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUnvipUserName, GetJavaInstance_String(gActiveJavaEnvironment, unvipUserName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["revokeVIP"], jUnvipUserName) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatMessageHandlerCallbacksProxy::ListVIPs() {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["listVIPs"]) == JNI_TRUE;
}
