/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_chatraidlistenerproxy.h"

#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;

ttv::binding::java::JavaChatRaidListenerProxy::JavaChatRaidListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IChatRaidListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaChatRaidListenerProxy::RaidStarted(const RaidStatus& status) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRaidStatus, GetJavaInstance_ChatRaidStatus(gActiveJavaEnvironment, status));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["raidStarted"], jRaidStatus);
}

void ttv::binding::java::JavaChatRaidListenerProxy::RaidUpdated(const RaidStatus& status) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRaidStatus, GetJavaInstance_ChatRaidStatus(gActiveJavaEnvironment, status));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["raidUpdated"], jRaidStatus);
}

void ttv::binding::java::JavaChatRaidListenerProxy::RaidFired(const RaidStatus& status) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRaidStatus, GetJavaInstance_ChatRaidStatus(gActiveJavaEnvironment, status));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["raidFired"], jRaidStatus);
}

void ttv::binding::java::JavaChatRaidListenerProxy::RaidCancelled(const RaidStatus& status) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRaidStatus, GetJavaInstance_ChatRaidStatus(gActiveJavaEnvironment, status));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["raidCancelled"], jRaidStatus);
}
