/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/generated/java_chatroommessagehandler.h"

#include "twitchsdk/chat/chatroommessagehandler.h"
#include "twitchsdk/chat/java_chatroommessagehandlercallbacksproxy.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;
using namespace ttv::binding::java;

JNIEXPORT jlong JNICALL Java_tv_twitch_chat_ChatRoomMessageHandler_CreateNativeInstance(JNIEnv* jEnv, jobject jThis) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  // Force load all types to ensure all classes are loaded by the time we need them.
  LoadAllChatJavaClassInfo(jEnv);

  std::shared_ptr<ChatRoomMessageHandlerContext> context = std::make_shared<ChatRoomMessageHandlerContext>();

  context->chatRoomMessageHandler = std::make_shared<ChatRoomMessageHandler>();
  context->callbacks = std::make_shared<JavaChatRoomMessageHandlerCallbacksProxy>();

  gChatRoomMessageHandlerRegistry.Register(context->chatRoomMessageHandler, context, jThis);
  context->chatRoomMessageHandler->SetCallbacks(context->callbacks);

  return reinterpret_cast<jlong>(context->chatRoomMessageHandler.get());
}

JNIEXPORT void JNICALL Java_tv_twitch_chat_ChatRoomMessageHandler_DisposeNativeInstance(
  JNIEnv* /*jEnv*/, jobject /*jThis*/, jlong jNativePointer) {
  gChatRoomMessageHandlerRegistry.Unregister(jNativePointer);
}

JNIEXPORT void JNICALL Java_tv_twitch_chat_ChatRoomMessageHandler_SetCallbacks(
  JNIEnv* jEnv, jobject /*jThis*/, jlong jNativePointer, jobject jICallbacks) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  auto context = gChatRoomMessageHandlerRegistry.LookupNativeContext(jNativePointer);
  if (context != nullptr) {
    std::shared_ptr<JavaChatRoomMessageHandlerCallbacksProxy> callbacksProxy;

    auto& callbacks = context->callbacks;
    if (callbacks != nullptr) {
      callbacksProxy = callbacks;
    }

    if (jICallbacks != nullptr) {
      if (callbacksProxy == nullptr) {
        callbacksProxy = std::make_shared<JavaChatRoomMessageHandlerCallbacksProxy>();
      }

      context->chatRoomMessageHandler->SetCallbacks(callbacksProxy);
      callbacksProxy->SetListener(jICallbacks);
    }
  }
}

JNIEXPORT jboolean JNICALL Java_tv_twitch_chat_ChatRoomMessageHandler_HandleMessage(
  JNIEnv* jEnv, jobject /*jThis*/, jlong jNativePointer, jstring jMessage) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  auto context = gChatRoomMessageHandlerRegistry.LookupNativeContext(jNativePointer);
  if (context != nullptr) {
    ScopedJavaUTFStringConverter message(jEnv, jMessage);
    bool result = context->chatRoomMessageHandler->HandleMessage(message.GetNativeString());

    return result ? JNI_TRUE : JNI_FALSE;
  }

  return JNI_FALSE;
}
