/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_chatroommessagehandlercallbacksproxy.h"

#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;

ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::JavaChatRoomMessageHandlerCallbacksProxy() {
  mListenerInfo = GetJavaClassInfo_ChatRoomMessageHandler_ICallbacks(gActiveJavaEnvironment);
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::PassThrough(const std::string& message) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jMessage, GetJavaInstance_String(gActiveJavaEnvironment, message));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["passThrough"], jMessage) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::BanUser(const std::string& userName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUserName, GetJavaInstance_String(gActiveJavaEnvironment, userName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["banUser"], jUserName) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::TimeoutUser(
  const std::string& userName, uint32_t duration) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUserName, GetJavaInstance_String(gActiveJavaEnvironment, userName));

  return gActiveJavaEnvironment->CallBooleanMethod(
           jListener, mListenerInfo.methods["timeoutUser"], jUserName, static_cast<jint>(duration)) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::BlockUser(const std::string& userName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUserName, GetJavaInstance_String(gActiveJavaEnvironment, userName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["blockUser"], jUserName) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::SetUserColor(const std::string& color) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jColor, GetJavaInstance_String(gActiveJavaEnvironment, color));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["setUserColor"], jColor) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::Help() {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["help"]) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::ListRooms() {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["listRooms"]) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::ModUser(const std::string& userName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUserName, GetJavaInstance_String(gActiveJavaEnvironment, userName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["modUser"], jUserName) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::ListModerators() {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["listModerators"]) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::SetTopic(const std::string& topic) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jTopic, GetJavaInstance_String(gActiveJavaEnvironment, topic));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["setTopic"], jTopic) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::UnbanUser(const std::string& userName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUserName, GetJavaInstance_String(gActiveJavaEnvironment, userName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["unbanUser"], jUserName) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::UnmodUser(const std::string& userName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUserName, GetJavaInstance_String(gActiveJavaEnvironment, userName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["unmodUser"], jUserName) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::UntimeoutUser(const std::string& userName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUserName, GetJavaInstance_String(gActiveJavaEnvironment, userName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["untimeoutUser"], jUserName) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::UnblockUser(const std::string& userName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUserName, GetJavaInstance_String(gActiveJavaEnvironment, userName));

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["unblockUser"], jUserName) ==
         JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::SlowMode(bool turnOn, uint32_t durationSeconds) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  return gActiveJavaEnvironment->CallBooleanMethod(jListener, mListenerInfo.methods["slowMode"],
           turnOn ? JNI_TRUE : JNI_FALSE, static_cast<jint>(durationSeconds)) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::R9kMode(bool turnOn) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  return gActiveJavaEnvironment->CallBooleanMethod(
           jListener, mListenerInfo.methods["r9kMode"], turnOn ? JNI_TRUE : JNI_FALSE) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::EmotesOnlyMode(bool turnOn) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  return gActiveJavaEnvironment->CallBooleanMethod(
           jListener, mListenerInfo.methods["emotesOnlyMode"], turnOn ? JNI_TRUE : JNI_FALSE) == JNI_TRUE;
}

bool ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy::MalformedCommand(
  ChatRoomMessageHandler::CommandError command, const std::string& commandText) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return false;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jCommand,
    GetJavaInstance_ChatRoomMessageHandlerCommandError(gActiveJavaEnvironment, command));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jCommandText, GetJavaInstance_String(gActiveJavaEnvironment, commandText));

  return gActiveJavaEnvironment->CallBooleanMethod(
           jListener, mListenerInfo.methods["malformedCommand"], jCommand, jCommandText) == JNI_TRUE;
}
