/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_chatuserthreadslistenerproxy.h"

#include "jni.h"
#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;

ttv::binding::java::JavaChatUserThreadsListenerProxy::JavaChatUserThreadsListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IChatUserThreadsListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaChatUserThreadsListenerProxy::ChatThreadRealtimeMessageReceived(
  UserId userId, const std::string& threadId, const WhisperMessage& message) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jThreadId, GetJavaInstance_String(gActiveJavaEnvironment, threadId));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jMessage, GetJavaInstance_ChatWhisperMessage(gActiveJavaEnvironment, message));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["chatThreadRealtimeMessageReceived"],
    static_cast<jint>(userId), jThreadId, jMessage);
}
