/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_followinglistenerproxy.h"

#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv;
using namespace ttv::chat;

ttv::binding::java::JavaFollowingListenerProxy::JavaFollowingListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IFollowingListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaFollowingListenerProxy::FollowedChannel(UserId userId, ChannelId channelId) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["followedChannel"], static_cast<jint>(userId), static_cast<jint>(channelId));
}

void ttv::binding::java::JavaFollowingListenerProxy::UnfollowedChannel(UserId userId, ChannelId channelId) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["unfollowedChannel"], static_cast<jint>(userId), static_cast<jint>(channelId));
}
