/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_ichannelchatroommanagerlistener_proxy.h"

#include "jni.h"
#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv::binding::java;

ttv::binding::java::JavaIChannelChatRoomManagerListenerProxy::JavaIChannelChatRoomManagerListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IChannelChatRoomManagerListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaIChannelChatRoomManagerListenerProxy::PurgeMessages(
  UserId userId, ChannelId channelId, Timestamp purgeAfter) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["purgeMessages"], static_cast<jint>(userId),
    static_cast<jint>(channelId), static_cast<jint>(purgeAfter));
}

void ttv::binding::java::JavaIChannelChatRoomManagerListenerProxy::RoomCreated(
  ChannelId ownerId, ChatRoomInfo&& roomInfo) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRoomInfo, GetJavaInstance_ChatRoomInfo(gActiveJavaEnvironment, roomInfo));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["roomCreated"], static_cast<jint>(ownerId), jRoomInfo);
}

void ttv::binding::java::JavaIChannelChatRoomManagerListenerProxy::RoomDeleted(
  ChannelId ownerId, ChatRoomInfo&& roomInfo) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRoomInfo, GetJavaInstance_ChatRoomInfo(gActiveJavaEnvironment, roomInfo));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["roomDeleted"], static_cast<jint>(ownerId), jRoomInfo);
}
