/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_ichatchannelpropertylistenerproxy.h"

#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv::binding::java;

ttv::binding::java::JavaIChatChannelPropertyListenerProxy::JavaIChatChannelPropertyListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IChatChannelPropertyListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaIChatChannelPropertyListenerProxy::RitualsEnabled(bool ritualsEnabled) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["ritualsEnabled"], ritualsEnabled ? JNI_TRUE : JNI_FALSE);
}

void ttv::binding::java::JavaIChatChannelPropertyListenerProxy::OutgoingHostChanged(ChannelId channelId,
  ChannelId previousTarget, ChannelId currentTarget, std::string&& currentTargetName, uint32_t numViewers) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jTargetName,
    GetJavaInstance_String(gActiveJavaEnvironment, std::move(currentTargetName)));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["outgoingHostChanged"],
    static_cast<jint>(channelId), static_cast<jint>(previousTarget), static_cast<jint>(currentTarget), jTargetName,
    static_cast<jint>(numViewers));
}

void ttv::binding::java::JavaIChatChannelPropertyListenerProxy::IncomingHostStarted(
  ChannelId channelId, ChannelId hostChannelId, std::string&& hostChannelName, uint32_t numViewers) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jHostName,
    GetJavaInstance_String(gActiveJavaEnvironment, std::move(hostChannelName)));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["incomingHostStarted"],
    static_cast<jint>(channelId), static_cast<jint>(hostChannelId), jHostName, static_cast<jint>(numViewers));
}

void ttv::binding::java::JavaIChatChannelPropertyListenerProxy::IncomingHostEnded(
  ChannelId channelId, ChannelId hostChannelId, std::string&& hostChannelName) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jHostName,
    GetJavaInstance_String(gActiveJavaEnvironment, std::move(hostChannelName)));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["incomingHostEnded"],
    static_cast<jint>(channelId), static_cast<jint>(hostChannelId), jHostName);
}

void ttv::binding::java::JavaIChatChannelPropertyListenerProxy::ExtensionMessageReceived(ExtensionMessage&& message) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jExtensionMessage,
    GetJavaInstance_ExtensionMessage(gActiveJavaEnvironment, std::move(message)));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["extensionMessageReceived"], jExtensionMessage);
}

void ttv::binding::java::JavaIChatChannelPropertyListenerProxy::ChatChannelRestrictionsReceived(
  ChatChannelRestrictions&& chatChannelRestrictions) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jChatChannelRestrictions,
    GetJavaInstance_ChatChannelRestrictions(gActiveJavaEnvironment, std::move(chatChannelRestrictions)));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["chatChannelRestrictionsReceived"], jChatChannelRestrictions);
}
