/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_ichatcommentlistener_proxy.h"

#include "jni.h"
#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

ttv::binding::java::JavaIChatCommentListenerProxy::JavaIChatCommentListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IChatCommentListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaIChatCommentListenerProxy::ChatCommentManagerStateChanged(
  UserId userId, const std::string& vodId, ttv::chat::IChatCommentManager::PlayingState state) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jVodId, GetJavaInstance_String(gActiveJavaEnvironment, vodId));
  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jState,
    GetJavaInstance_SimpleEnum(gActiveJavaEnvironment, GetJavaClassInfo_PlayingState(gActiveJavaEnvironment), state));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["chatCommentManagerStateChanged"], static_cast<jint>(userId), jVodId, jState);
}

void ttv::binding::java::JavaIChatCommentListenerProxy::ChatCommentsReceived(
  UserId userId, const std::string& vodId, std::vector<ttv::chat::ChatComment>&& messageList) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jVodId, GetJavaInstance_String(gActiveJavaEnvironment, vodId));
  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jMessages,
    GetJavaInstance_ChatCommentArray(gActiveJavaEnvironment, std::move(messageList)));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["chatCommentsReceived"], static_cast<jint>(userId), jVodId, jMessages);
}

void ttv::binding::java::JavaIChatCommentListenerProxy::ChatCommentsErrorReceived(
  const std::string& errorMsg, TTV_ErrorCode ec) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jErrorMsg, GetJavaInstance_String(gActiveJavaEnvironment, errorMsg));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["chatCommentsErrorReceived"], jErrorMsg, static_cast<jint>(ec));
}
