/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_ichatroomlistener_proxy.h"

#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv::binding::java;
using namespace ttv::chat;

ttv::binding::java::JavaIChatRoomListenerProxy::JavaIChatRoomListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IChatRoomListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaIChatRoomListenerProxy::MessageReceived(
  const std::string& roomId, ChatRoomMessage&& message) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRoomId, GetJavaInstance_String(gActiveJavaEnvironment, roomId));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jMessage, GetJavaInstance_ChatRoomMessage(gActiveJavaEnvironment, message));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["messageReceived"], jRoomId, jMessage);
}

void ttv::binding::java::JavaIChatRoomListenerProxy::MessageEdited(
  const std::string& roomId, ChatRoomMessage&& message) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRoomId, GetJavaInstance_String(gActiveJavaEnvironment, roomId));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jMessage, GetJavaInstance_ChatRoomMessage(gActiveJavaEnvironment, message));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["messageEdited"], jRoomId, jMessage);
}

void ttv::binding::java::JavaIChatRoomListenerProxy::MessageDeleted(
  const std::string& roomId, ChatRoomMessage&& message) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRoomId, GetJavaInstance_String(gActiveJavaEnvironment, roomId));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jMessage, GetJavaInstance_ChatRoomMessage(gActiveJavaEnvironment, message));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["messageDeleted"], jRoomId, jMessage);
}

void ttv::binding::java::JavaIChatRoomListenerProxy::RoomUpdated(ChatRoomInfo&& roomInfo) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRoomInfo, GetJavaInstance_ChatRoomInfo(gActiveJavaEnvironment, roomInfo));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["roomUpdated"], jRoomInfo);
}
