/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/chat/internal/pch.h"

#include "twitchsdk/chat/java_ichatroomnotificationslistener_proxy.h"

#include "twitchsdk/chat/chatapi.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/generated/java_all.h"
#include "twitchsdk/chat/java_chatutil.h"

using namespace ttv::binding::java;

ttv::binding::java::JavaIChatRoomNotificationsListenerProxy::JavaIChatRoomNotificationsListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IChatRoomNotificationsListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaIChatRoomNotificationsListenerProxy::UserTimedOut(
  UserId userId, ChannelId channelId, Timestamp expiresAt) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["userTimedOut"], static_cast<jint>(userId),
    static_cast<jint>(channelId), static_cast<jint>(expiresAt));
}

void ttv::binding::java::JavaIChatRoomNotificationsListenerProxy::UserBanned(UserId userId, ChannelId channelId) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["userBanned"], static_cast<jint>(userId), static_cast<jint>(channelId));
}

void ttv::binding::java::JavaIChatRoomNotificationsListenerProxy::UserUnbanned(UserId userId, ChannelId channelId) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["userUnbanned"], static_cast<jint>(userId), static_cast<jint>(channelId));
}

void ttv::binding::java::JavaIChatRoomNotificationsListenerProxy::RoomViewUpdated(
  UserId userId, ChannelId ownerId, const std::string& roomId, ChatRoomView&& roomViewInfo) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jRoomId, GetJavaInstance_String(gActiveJavaEnvironment, roomId));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jViewInfo, GetJavaInstance_ChatRoomView(gActiveJavaEnvironment, roomViewInfo));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["roomViewUpdated"], static_cast<jint>(userId),
    static_cast<jint>(ownerId), jRoomId, jViewInfo);
}

void ttv::binding::java::JavaIChatRoomNotificationsListenerProxy::RoomMentionReceived(
  UserId userId, RoomMentionInfo&& mentionInfo) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jMentionInfo,
    GetJavaInstance_RoomMentionInfo(gActiveJavaEnvironment, mentionInfo));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["roomMentionReceived"], static_cast<jint>(userId), jMentionInfo);
}
